/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.RhinoHelper;

public final class SchemaNode {
    private static final JsonNode EMPTY_SCHEMA = JsonNodeFactory.instance.objectNode();
    private final SchemaContainer container;
    private final JsonNode node;
    private JsonNode additionalItems = EMPTY_SCHEMA;
    private final List<JsonNode> items = new ArrayList<JsonNode>();
    private JsonNode additionalProperties = EMPTY_SCHEMA;
    private final Map<String, JsonNode> properties = new HashMap<String, JsonNode>();
    private final Map<String, JsonNode> patternProperties = new HashMap<String, JsonNode>();

    public SchemaNode(SchemaContainer container, JsonNode node) {
        this.container = container;
        this.node = node;
        this.setupArraySchemas();
        this.setupObjectSchemas();
    }

    public SchemaContainer getContainer() {
        return this.container;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public JsonNode getArraySchema(int index) {
        return index < this.items.size() ? this.items.get(index) : this.additionalItems;
    }

    public Set<JsonNode> getObjectSchemas(String key) {
        HashSet<JsonNode> ret = new HashSet<JsonNode>();
        if (this.properties.containsKey(key)) {
            ret.add(this.properties.get(key));
        }
        for (String regex : this.patternProperties.keySet()) {
            if (!RhinoHelper.regMatch(regex, key)) continue;
            ret.add(this.patternProperties.get(regex));
        }
        if (ret.isEmpty()) {
            ret.add(this.additionalProperties);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SchemaNode that = (SchemaNode)o;
        return this.container.equals(that.container) && this.node.equals((Object)that.node);
    }

    public int hashCode() {
        return 31 * this.container.hashCode() + this.node.hashCode();
    }

    private void setupArraySchemas() {
        JsonNode tmp = this.node.path("items");
        if (tmp.isObject()) {
            this.additionalItems = tmp;
            return;
        }
        if (tmp.isArray()) {
            for (JsonNode item : tmp) {
                this.items.add(item);
            }
        }
        if ((tmp = this.node.path("additionalItems")).isObject()) {
            this.additionalItems = tmp;
        }
    }

    private void setupObjectSchemas() {
        JsonNode tmp = this.node.path("additionalProperties");
        if (tmp.isObject()) {
            this.additionalProperties = tmp;
        }
        if ((tmp = this.node.path("properties")).isObject()) {
            this.properties.putAll(CollectionUtils.toMap(tmp.fields()));
        }
        if ((tmp = this.node.path("patternProperties")).isObject()) {
            this.patternProperties.putAll(CollectionUtils.toMap(tmp.fields()));
        }
    }
}

