/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.JsonPointer;

public final class ValidJsonSchema
implements JsonSchema {
    private final JsonSchemaFactory factory;
    private final JsonValidator validator;
    private final SchemaContainer container;
    private final SchemaNode schemaNode;

    public ValidJsonSchema(JsonSchemaFactory factory, SchemaContainer container, SchemaNode schemaNode) {
        this.factory = factory;
        this.validator = factory.getValidatorFactory().fromNode(schemaNode.getNode());
        this.container = container;
        this.schemaNode = schemaNode;
    }

    @Override
    public void validate(ValidationContext ctx, JsonNode instance) {
        ctx.setFactory(this.factory);
        ctx.setContainer(this.container);
        this.validator.validate(ctx, instance);
        if (!ctx.isSuccess()) {
            return;
        }
        if (!instance.isContainerNode()) {
            return;
        }
        if (instance.isArray()) {
            this.validateArray(ctx, instance);
        } else {
            this.validateObject(ctx, instance);
        }
    }

    private void validateArray(ValidationContext ctx, JsonNode instance) {
        JsonPointer cwd = ctx.getPath();
        int idx = 0;
        for (JsonNode element : instance) {
            JsonNode node = this.schemaNode.getArraySchema(idx);
            JsonPointer ptr = cwd.append(idx);
            ctx.setPath(ptr);
            JsonSchema subSchema = this.factory.create(this.container, node);
            subSchema.validate(ctx, element);
            ++idx;
        }
        ctx.setPath(cwd);
    }

    private void validateObject(ValidationContext ctx, JsonNode instance) {
        Set<String> fieldNames = CollectionUtils.toSet(instance.fieldNames());
        JsonPointer cwd = ctx.getPath();
        for (String field : fieldNames) {
            JsonNode element = instance.get(field);
            Set<JsonNode> nodeSet = this.schemaNode.getObjectSchemas(field);
            JsonPointer ptr = cwd.append(field);
            ctx.setPath(ptr);
            for (JsonNode node : nodeSet) {
                JsonSchema subSchema = this.factory.create(this.container, node);
                subSchema.validate(ctx, element);
            }
        }
        ctx.setPath(cwd);
    }
}

