/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.util.NodeType;

public class ArrayChildrenSyntaxChecker
extends SimpleSyntaxChecker {
    private final EnumSet<NodeType> childrenTypes;

    protected ArrayChildrenSyntaxChecker(String keyword, EnumSet<NodeType> childrenTypes, NodeType type, NodeType ... types) {
        super(keyword, type, types);
        this.childrenTypes = EnumSet.copyOf(childrenTypes);
    }

    @Override
    final void checkValue(ValidationContext context, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            return;
        }
        for (JsonNode value : node) {
            if (this.childrenTypes.contains((Object)NodeType.getNodeType(value))) continue;
            context.addMessage("wrong element type in array");
        }
    }
}

