/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class DependenciesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DependenciesSyntaxChecker();

    private DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode schema) {
        block4: for (JsonNode value : schema.get(this.keyword)) {
            switch (NodeType.getNodeType(value)) {
                case ARRAY: {
                    for (JsonNode element : value) {
                        if (element.isTextual()) continue;
                        context.addMessage("array element is not a string");
                    }
                }
                case OBJECT: 
                case STRING: {
                    continue block4;
                }
            }
            context.addMessage("dependencies element has wrong type");
        }
    }
}

