/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class DivisibleBySyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DivisibleBySyntaxChecker();

    private DivisibleBySyntaxChecker() {
        super("divisibleBy", NodeType.INTEGER, NodeType.NUMBER);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode schema) {
        BigDecimal decimal = schema.get(this.keyword).decimalValue();
        if (BigDecimal.ZERO.compareTo(decimal) == 0) {
            context.addMessage("divisibleBy is 0");
        }
    }
}

