/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class EnumSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new EnumSyntaxChecker();

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode schema) {
        HashSet<JsonNode> values = new HashSet<JsonNode>();
        for (JsonNode value : schema.get(this.keyword)) {
            if (values.add(value)) continue;
            context.addMessage("values in an enum must be unique");
            return;
        }
    }
}

