/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;
import org.eel.kitchen.util.RhinoHelper;

public final class PatternPropertiesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode schema) {
        Map properties = CollectionUtils.toMap(schema.get(this.keyword).fields());
        for (Map.Entry entry : properties.entrySet()) {
            if (!RhinoHelper.regexIsValid((String)entry.getKey())) {
                context.addMessage("invalid regex");
                continue;
            }
            if (((JsonNode)entry.getValue()).isObject()) continue;
            context.addMessage("value is not a schema");
        }
    }
}

