/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.util.NodeType;

public class PositiveIntegerSyntaxChecker
extends SimpleSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    final void checkValue(ValidationContext context, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.canConvertToInt()) {
            context.addMessage("value overflow");
            return;
        }
        if (node.intValue() < 0) {
            context.addMessage("value is negative");
        }
    }
}

