/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public class SimpleSyntaxChecker
implements SyntaxChecker {
    protected final String keyword;
    private final EnumSet<NodeType> validTypes;

    public SimpleSyntaxChecker(String keyword, NodeType type, NodeType ... types) {
        this.keyword = keyword;
        this.validTypes = EnumSet.of(type, types);
    }

    @Override
    public final void checkSyntax(ValidationContext context, JsonNode schema) {
        NodeType nodeType = NodeType.getNodeType(schema.get(this.keyword));
        if (!this.validTypes.contains((Object)nodeType)) {
            context.addMessage("keyword is of wrong type");
            return;
        }
        this.checkValue(context, schema);
    }

    void checkValue(ValidationContext context, JsonNode schema) {
    }
}

