/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.CollectionUtils;

public final class SyntaxValidator {
    private final Set<JsonNode> done = new HashSet<JsonNode>();
    private final Map<String, SyntaxChecker> checkers = new HashMap<String, SyntaxChecker>();

    public SyntaxValidator(KeywordBundle bundle) {
        for (Map.Entry<String, Keyword> entry : bundle) {
            String name = entry.getKey();
            SyntaxChecker checker = entry.getValue().getSyntaxChecker();
            if (checker == null) continue;
            this.checkers.put(name, checker);
        }
    }

    public synchronized void validate(ValidationContext context, JsonNode schema) {
        if (this.done.contains(schema)) {
            return;
        }
        Set<String> keywords = CollectionUtils.toSet(schema.fieldNames());
        keywords.retainAll(this.checkers.keySet());
        for (String keyword : keywords) {
            this.checkers.get(keyword).checkSyntax(context, schema);
        }
        if (context.isSuccess()) {
            this.done.add(schema);
        }
    }
}

