/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.util.NodeType;

public class TypeKeywordSyntaxChecker
extends SimpleSyntaxChecker {
    private static final String ANY = "any";

    public TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    final void checkValue(ValidationContext context, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            this.validateOne(context, node);
            return;
        }
        HashSet<JsonNode> set = new HashSet<JsonNode>();
        for (JsonNode value : node) {
            if (!set.add(value)) {
                context.addMessage("items in the array must be unique");
                return;
            }
            this.validateOne(context, value);
        }
    }

    private void validateOne(ValidationContext context, JsonNode value) {
        if (value.isObject()) {
            return;
        }
        if (!value.isTextual()) {
            context.addMessage("value has wrong type");
            return;
        }
        String s = value.textValue();
        if (ANY.equals(s)) {
            return;
        }
        if (NodeType.fromName(s) == null) {
            context.addMessage("unknown simple type");
        }
    }
}

