/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.keyword.KeywordFactory;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.validator.InvalidJsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.SimpleJsonValidator;

public final class JsonValidatorFactory {
    private final LoadingCache<JsonNode, JsonValidator> cache;

    public JsonValidatorFactory(KeywordBundle bundle) {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new ValidatorBuilder(bundle));
    }

    public JsonValidator fromNode(JsonNode schemaNode) {
        return (JsonValidator)this.cache.getUnchecked((Object)schemaNode);
    }

    private static class ValidatorBuilder
    extends CacheLoader<JsonNode, JsonValidator> {
        private final SyntaxValidator syntaxValidator;
        private final KeywordFactory keywordFactory;

        ValidatorBuilder(KeywordBundle bundle) {
            this.syntaxValidator = new SyntaxValidator(bundle);
            this.keywordFactory = new KeywordFactory(bundle);
        }

        public JsonValidator load(JsonNode key) {
            ValidationContext ctx = new ValidationContext();
            this.syntaxValidator.validate(ctx, key);
            if (!ctx.isSuccess()) {
                return new InvalidJsonValidator(ctx);
            }
            Set<KeywordValidator> validators = this.keywordFactory.getValidators(key);
            return new SimpleJsonValidator(validators);
        }
    }
}

