/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.bundle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eel.kitchen.jsonschema.bundle.Keyword;

public final class KeywordBundle
implements Iterable<Map.Entry<String, Keyword>> {
    private final Map<String, Keyword> keywords = new HashMap<String, Keyword>();

    KeywordBundle copy() {
        KeywordBundle ret = new KeywordBundle();
        ret.keywords.putAll(this.keywords);
        return ret;
    }

    public void registerKeyword(Keyword keyword) {
        String name = keyword.getName();
        Preconditions.checkArgument((!this.keywords.containsKey(name) ? 1 : 0) != 0, (Object)("keyword \"" + name + "\" already registered"));
        this.keywords.put(name, keyword);
    }

    public void unregisterKeyword(String name) {
        this.keywords.remove(name);
    }

    @Override
    public Iterator<Map.Entry<String, Keyword>> iterator() {
        return ImmutableMap.copyOf(this.keywords).entrySet().iterator();
    }
}

