/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import java.util.List;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class IPV4FormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new IPV4FormatSpecifier();
    private static final int IPV4_LENGTH = 4;

    private IPV4FormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode value) {
        String ipaddr = value.textValue();
        if (!InetAddresses.isInetAddress((String)ipaddr)) {
            messages.add("string is not a valid IPv4 address");
            return;
        }
        if (InetAddresses.forString((String)ipaddr).getAddress().length != 4) {
            messages.add("string is not a valid IPv4 address");
        }
    }
}

