/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.util.List;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class UnixEpochFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new UnixEpochFormatSpecifier();
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");

    private UnixEpochFormatSpecifier() {
        super(NodeType.INTEGER, NodeType.NUMBER);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode value) {
        BigInteger epoch = value.bigIntegerValue();
        if (epoch.signum() == -1) {
            messages.add("epoch cannot be negative");
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            messages.add("epoch time would overflow");
        }
    }
}

