/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class AdditionalPropertiesKeywordValidator
extends KeywordValidator {
    private final boolean additionalOK;
    private final Set<String> properties;
    private final Set<String> patternProperties;

    public AdditionalPropertiesKeywordValidator(JsonNode schema) {
        super(NodeType.OBJECT);
        this.additionalOK = schema.get("additionalProperties").asBoolean(true);
        if (this.additionalOK) {
            this.properties = Collections.emptySet();
            this.patternProperties = Collections.emptySet();
            return;
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (schema.has("properties")) {
            builder.addAll(schema.get("properties").fieldNames());
        }
        this.properties = builder.build();
        builder = new ImmutableSet.Builder();
        if (schema.has("patternProperties")) {
            builder.addAll(schema.get("patternProperties").fieldNames());
        }
        this.patternProperties = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.additionalOK) {
            return;
        }
        Set<String> fields = JacksonUtils.fieldNames(instance);
        fields.removeAll(this.properties);
        HashSet<String> tmp = new HashSet<String>();
        for (String field : fields) {
            for (String regex : this.patternProperties) {
                if (!RhinoHelper.regMatch(regex, field)) continue;
                tmp.add(field);
            }
        }
        fields.removeAll(tmp);
        if (!fields.isEmpty()) {
            report.addMessage("additional properties not permitted");
        }
    }
}

