/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;

public final class DisallowKeywordValidator
extends AbstractTypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode schema) {
        super("disallow", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            report.addMessage("instance is of a disallowed primitive type");
            return;
        }
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode schema : this.schemas) {
            SchemaNode subNode = new SchemaNode(container, schema);
            JsonValidator validator = new RefResolverJsonValidator(factory, subNode);
            ValidationReport subReport = report.copy();
            while (validator.validate(context, subReport, instance)) {
                validator = validator.next();
            }
            context.setContainer(container);
            if (!subReport.isSuccess()) continue;
            report.addMessage("instance matches a disallowed schema");
            return;
        }
    }
}

