/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class EnumKeywordValidator
extends KeywordValidator {
    private final Set<JsonNode> enumValues;

    public EnumKeywordValidator(JsonNode schema) {
        super(NodeType.values());
        this.enumValues = ImmutableSet.copyOf((Iterable)schema.get("enum"));
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (!this.enumValues.contains(instance)) {
            report.addMessage("instance does not match any enum value");
        }
    }
}

