/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;

public final class ExtendsKeywordValidator
extends KeywordValidator {
    private final Set<JsonNode> schemas;

    public ExtendsKeywordValidator(JsonNode schema) {
        super(NodeType.values());
        JsonNode node = schema.get("extends");
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (node.isObject()) {
            builder.add((Object)node);
        } else {
            builder.addAll((Iterable)node);
        }
        this.schemas = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode schema : this.schemas) {
            SchemaNode subNode = new SchemaNode(container, schema);
            JsonValidator validator = new RefResolverJsonValidator(factory, subNode);
            while (validator.validate(context, report, instance)) {
                validator = validator.next();
            }
            context.setContainer(container);
        }
    }
}

