/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.DateFormatSpecifier;
import org.eel.kitchen.jsonschema.format.DateTimeFormatSpecifier;
import org.eel.kitchen.jsonschema.format.DateTimeMillisecFormatSpecifier;
import org.eel.kitchen.jsonschema.format.EmailFormatSpecifier;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.format.HostnameFormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV4FormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV6FormatSpecifier;
import org.eel.kitchen.jsonschema.format.PhoneNumberFormatSpecifier;
import org.eel.kitchen.jsonschema.format.RegexFormatSpecifier;
import org.eel.kitchen.jsonschema.format.TimeFormatSpecifier;
import org.eel.kitchen.jsonschema.format.URIFormatSpecifier;
import org.eel.kitchen.jsonschema.format.UnixEpochFormatSpecifier;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class FormatKeywordValidator
extends KeywordValidator {
    private static final Map<String, FormatSpecifier> specifiers;
    private final FormatSpecifier specifier;

    public FormatKeywordValidator(JsonNode schema) {
        super(NodeType.values());
        this.specifier = specifiers.get(schema.get("format").textValue());
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.specifier == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        this.specifier.validate(messages, instance);
        report.addMessages(messages);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"date-time", (Object)DateTimeFormatSpecifier.getInstance());
        builder.put((Object)"date", (Object)DateFormatSpecifier.getInstance());
        builder.put((Object)"time", (Object)TimeFormatSpecifier.getInstance());
        builder.put((Object)"utc-millisec", (Object)UnixEpochFormatSpecifier.getInstance());
        builder.put((Object)"regex", (Object)RegexFormatSpecifier.getInstance());
        builder.put((Object)"phone", (Object)PhoneNumberFormatSpecifier.getInstance());
        builder.put((Object)"uri", (Object)URIFormatSpecifier.getInstance());
        builder.put((Object)"email", (Object)EmailFormatSpecifier.getInstance());
        builder.put((Object)"ip-address", (Object)IPV4FormatSpecifier.getInstance());
        builder.put((Object)"ipv6", (Object)IPV6FormatSpecifier.getInstance());
        builder.put((Object)"host-name", (Object)HostnameFormatSpecifier.getInstance());
        builder.put((Object)"date-time-ms", (Object)DateTimeMillisecFormatSpecifier.getInstance());
        specifiers = builder.build();
    }
}

