/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class KeywordFactory {
    private final Map<String, Class<? extends KeywordValidator>> validators;

    public KeywordFactory(KeywordBundle bundle) {
        HashMap<String, Class<? extends KeywordValidator>> map = new HashMap<String, Class<? extends KeywordValidator>>();
        for (Map.Entry<String, Keyword> entry : bundle) {
            String keyword = entry.getKey();
            Class<? extends KeywordValidator> validatorClass = entry.getValue().getValidatorClass();
            if (validatorClass == null) continue;
            map.put(keyword, validatorClass);
        }
        this.validators = ImmutableMap.copyOf(map);
    }

    public Set<KeywordValidator> getValidators(JsonNode schema) {
        HashSet<KeywordValidator> ret = new HashSet<KeywordValidator>();
        Set<String> set = JacksonUtils.fieldNames(schema);
        set.retainAll(this.validators.keySet());
        for (String keyword : set) {
            ret.add(KeywordFactory.buildValidator(this.validators.get(keyword), schema));
        }
        return ImmutableSet.copyOf(ret);
    }

    private static KeywordValidator buildValidator(Class<? extends KeywordValidator> c, JsonNode schema) {
        Constructor<? extends KeywordValidator> constructor;
        try {
            constructor = c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            return KeywordFactory.invalidValidator(e);
        }
        try {
            return constructor.newInstance(schema);
        }
        catch (InstantiationException e) {
            return KeywordFactory.invalidValidator(e);
        }
        catch (IllegalAccessException e) {
            return KeywordFactory.invalidValidator(e);
        }
        catch (InvocationTargetException e) {
            return KeywordFactory.invalidValidator(e);
        }
    }

    private static KeywordValidator invalidValidator(final Exception e) {
        return new KeywordValidator(NodeType.values()){

            @Override
            protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
                report.addMessage("cannot build validator: " + e.getClass().getName() + ": " + e.getMessage());
            }
        };
    }
}

