/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class PropertiesKeywordValidator
extends KeywordValidator {
    private final Set<String> required;

    public PropertiesKeywordValidator(JsonNode schema) {
        super(NodeType.OBJECT);
        Map<String, JsonNode> map = JacksonUtils.nodeToMap(schema.get("properties"));
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            if (!entry.getValue().path("required").asBoolean(false)) continue;
            builder.add((Object)entry.getKey());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        Set<String> fields = JacksonUtils.fieldNames(instance);
        if (!fields.containsAll(this.required)) {
            report.addMessage("missing required properties in instance");
        }
    }
}

