/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;

public final class JsonSchema {
    private final JsonSchemaFactory factory;
    private final SchemaNode schemaNode;
    private final ValidationContext context;

    JsonSchema(JsonSchemaFactory factory, SchemaNode schemaNode) {
        this.factory = factory;
        this.schemaNode = schemaNode;
        this.context = new ValidationContext(factory);
        this.context.setContainer(schemaNode.getContainer());
    }

    public ValidationReport validate(JsonNode instance) {
        ValidationReport report = new ValidationReport();
        JsonValidator validator = new RefResolverJsonValidator(this.factory, this.schemaNode);
        while (validator.validate(this.context, report, instance)) {
            validator = validator.next();
        }
        return report;
    }
}

