/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.bundle.KeywordBundles;
import org.eel.kitchen.jsonschema.keyword.KeywordFactory;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.uri.URIDownloader;
import org.eel.kitchen.jsonschema.uri.URIManager;

public final class JsonSchemaFactory {
    private final Set<JsonNode> validated = new HashSet<JsonNode>();
    private final LoadingCache<JsonNode, Set<KeywordValidator>> cache;
    private final SyntaxValidator syntaxValidator;
    private final KeywordFactory keywordFactory;
    private final SchemaRegistry registry;

    private JsonSchemaFactory(Builder builder) {
        this.syntaxValidator = new SyntaxValidator(builder.bundle);
        this.keywordFactory = new KeywordFactory(builder.bundle);
        this.registry = new SchemaRegistry(builder.uriManager);
        CacheLoader<JsonNode, Set<KeywordValidator>> loader = new CacheLoader<JsonNode, Set<KeywordValidator>>(){

            public Set<KeywordValidator> load(JsonNode key) {
                return JsonSchemaFactory.this.keywordFactory.getValidators(key);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public SchemaContainer registerSchema(JsonNode schema) throws JsonSchemaException {
        return this.registry.register(schema);
    }

    public SchemaContainer getSchema(URI uri) throws JsonSchemaException {
        return this.registry.get(uri);
    }

    public JsonSchema createSchema(SchemaContainer container) {
        return this.createSchema(container, container.getSchema());
    }

    public JsonSchema createSchema(SchemaContainer container, String path) {
        ObjectNode node = JsonNodeFactory.instance.objectNode().put("$ref", path);
        return this.createSchema(container, (JsonNode)node);
    }

    public JsonSchema createSchema(SchemaContainer container, JsonNode schema) {
        return new JsonSchema(this, new SchemaNode(container, schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSyntax(List<String> messages, JsonNode node) {
        if (!node.isObject()) {
            messages.add("not a JSON Schema (not an object)");
            return;
        }
        Set<JsonNode> set = this.validated;
        synchronized (set) {
            if (this.validated.contains(node)) {
                return;
            }
            this.syntaxValidator.validate(messages, node);
            if (messages.isEmpty()) {
                this.validated.add(node);
            }
        }
    }

    public Set<KeywordValidator> getValidators(JsonNode node) {
        return (Set)this.cache.getUnchecked((Object)node);
    }

    public static final class Builder {
        private final KeywordBundle bundle;
        private final URIManager uriManager;

        public Builder() {
            this(KeywordBundles.defaultBundle());
        }

        public Builder(KeywordBundle bundle) {
            this.bundle = bundle;
            this.uriManager = new URIManager();
        }

        public Builder addURIDownloader(String scheme, URIDownloader downloader) {
            this.uriManager.registerDownloader(scheme, downloader);
            return this;
        }

        public Builder addKeyword(Keyword keyword) {
            this.bundle.registerKeyword(keyword);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this);
        }
    }
}

