/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonFragment;

public final class JsonPointer
extends JsonFragment
implements Comparable<JsonPointer> {
    private static final CharMatcher SPECIAL = CharMatcher.anyOf((CharSequence)"^/");
    private static final CharMatcher SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher CARET = CharMatcher.is((char)'^');
    private final String fullPointer;
    private final List<String> elements;

    public JsonPointer(String input) throws JsonSchemaException {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonPointer.process(input, (ImmutableList.Builder<String>)builder);
        this.elements = builder.build();
        this.fullPointer = '#' + input;
    }

    private JsonPointer(String fullPointer, List<String> elements) {
        this.fullPointer = fullPointer;
        this.elements = elements;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public JsonPointer append(String element) {
        ImmutableList newElements = ImmutableList.builder().addAll(this.elements).add((Object)element).build();
        return new JsonPointer(this.fullPointer + '/' + JsonPointer.refTokenEncode(element), (List<String>)newElements);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    @Override
    public JsonNode resolve(JsonNode node) {
        JsonNode ret = node;
        for (String pathElement : this.elements) {
            if (!ret.isContainerNode()) {
                return MissingNode.getInstance();
            }
            if (ret.isObject()) {
                ret = ret.path(pathElement);
            } else {
                try {
                    ret = ret.path(Integer.parseInt(pathElement));
                }
                catch (NumberFormatException ignored) {
                    return MissingNode.getInstance();
                }
            }
            if (!ret.isMissingNode()) continue;
            break;
        }
        return ret;
    }

    private static void process(String input, ImmutableList.Builder<String> builder) throws JsonSchemaException {
        String victim = input;
        while (!victim.isEmpty()) {
            if (!victim.startsWith("/")) {
                throw new JsonSchemaException("Illegal JSON Pointer");
            }
            victim = victim.substring(1);
            String cooked = JsonPointer.getNextRefToken(victim);
            victim = victim.substring(cooked.length());
            String raw = JsonPointer.refTokenDecode(cooked);
            builder.add((Object)raw);
        }
    }

    private static String getNextRefToken(String input) throws JsonSchemaException {
        StringBuilder sb = new StringBuilder();
        char[] array = input.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (inEscape) {
                if (!SPECIAL.matches(c)) {
                    throw new JsonSchemaException("illegal JSON Pointer");
                }
                sb.append(c);
                inEscape = false;
                continue;
            }
            if (SLASH.matches(c)) break;
            if (CARET.matches(c)) {
                inEscape = true;
            }
            sb.append(c);
        }
        if (inEscape) {
            throw new JsonSchemaException("illegal JSON Pointer");
        }
        return sb.toString();
    }

    private static String refTokenDecode(String cooked) {
        StringBuilder sb = new StringBuilder(cooked.length());
        char[] array = cooked.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (CARET.matches(c) && !inEscape) {
                inEscape = true;
                continue;
            }
            inEscape = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String refTokenEncode(String raw) {
        char[] array;
        StringBuilder sb = new StringBuilder(raw.length());
        for (char c : array = raw.toCharArray()) {
            if (SPECIAL.matches(c)) {
                sb.append('^');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(JsonPointer other) {
        return this.fullPointer.compareTo(other.fullPointer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPointer other = (JsonPointer)obj;
        return this.fullPointer.equals(other.fullPointer);
    }

    public int hashCode() {
        return this.fullPointer.hashCode();
    }

    @Override
    public String toString() {
        return this.fullPointer;
    }
}

