/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.List;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class EnumSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new EnumSyntaxChecker();

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode schema) {
        HashSet<JsonNode> values = new HashSet<JsonNode>();
        for (JsonNode value : schema.get(this.keyword)) {
            if (values.add(value)) continue;
            messages.add("values in an enum must be unique");
            return;
        }
        if (values.isEmpty()) {
            messages.add("an enum array must have at least one element");
        }
    }
}

