/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternPropertiesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode schema) {
        Map<String, JsonNode> properties = JacksonUtils.nodeToMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : properties.entrySet()) {
            if (!RhinoHelper.regexIsValid(entry.getKey())) {
                messages.add("invalid regex");
                continue;
            }
            if (entry.getValue().isObject()) continue;
            messages.add("value is not a schema");
        }
    }
}

