/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;

public final class SyntaxValidator {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxValidator(KeywordBundle bundle) {
        HashMap<String, SyntaxChecker> map = new HashMap<String, SyntaxChecker>();
        for (Map.Entry<String, Keyword> entry : bundle) {
            String name = entry.getKey();
            SyntaxChecker checker = entry.getValue().getSyntaxChecker();
            if (checker == null) continue;
            map.put(name, checker);
        }
        this.checkers = ImmutableMap.copyOf(map);
    }

    public void validate(List<String> messages, JsonNode schema) {
        Set<String> keywords = JacksonUtils.fieldNames(schema);
        keywords.retainAll(this.checkers.keySet());
        for (String keyword : keywords) {
            this.checkers.get(keyword).checkSyntax(messages, schema);
        }
    }
}

