/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.List;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class TypeKeywordSyntaxChecker
extends SimpleSyntaxChecker {
    private static final String ANY = "any";

    public TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    final void checkValue(List<String> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            TypeKeywordSyntaxChecker.validateOne(messages, node);
            return;
        }
        HashSet<JsonNode> set = new HashSet<JsonNode>();
        for (JsonNode value : node) {
            if (!set.add(value)) {
                messages.add("items in the array must be unique");
                return;
            }
            TypeKeywordSyntaxChecker.validateOne(messages, value);
        }
    }

    private static void validateOne(List<String> messages, JsonNode value) {
        if (value.isObject()) {
            return;
        }
        if (!value.isTextual()) {
            messages.add("value has wrong type");
            return;
        }
        String s = value.textValue();
        if (ANY.equals(s)) {
            return;
        }
        if (NodeType.fromName(s) == null) {
            messages.add("unknown simple type");
        }
    }
}

