/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.uri;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.uri.HTTPURIDownloader;
import org.eel.kitchen.jsonschema.uri.URIDownloader;

public class URIManager {
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private final Map<String, URIDownloader> downloaders = new HashMap<String, URIDownloader>();

    public URIManager() {
        this.downloaders.put("http", HTTPURIDownloader.getInstance());
    }

    public void registerDownloader(String scheme, URIDownloader downloader) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        Preconditions.checkArgument((!scheme.isEmpty() ? 1 : 0) != 0, (Object)"scheme is empty");
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException("illegal scheme \"" + scheme + '\"');
        }
        Preconditions.checkArgument((!this.downloaders.containsKey(scheme) ? 1 : 0) != 0, (Object)("scheme \"" + scheme + "\" already registered"));
        this.downloaders.put(scheme, downloader);
    }

    public JsonNode getContent(URI uri) throws JsonSchemaException {
        InputStream in;
        Preconditions.checkNotNull((Object)uri, (Object)"null URI");
        Preconditions.checkArgument((boolean)uri.isAbsolute(), (Object)("requested URI (" + uri + ") is not absolute"));
        String scheme = uri.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new JsonSchemaException("cannot handle scheme \"" + scheme + "\" (requested URI: " + uri + ')');
        }
        try {
            in = downloader.fetch(uri);
        }
        catch (IOException e) {
            throw new JsonSchemaException("cannot fetch content from URI \"" + uri + '\"', e);
        }
        try {
            return mapper.readTree(in);
        }
        catch (IOException e) {
            throw new JsonSchemaException("URI \"" + uri + "\" is not valid JSON", e);
        }
    }
}

