/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ArrayJsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ObjectJsonValidator;

public final class InstanceJsonValidator
implements JsonValidator {
    private final JsonSchemaFactory factory;
    private final SchemaNode schemaNode;
    private final Set<KeywordValidator> validators;
    private NodeType instanceType;

    InstanceJsonValidator(JsonSchemaFactory factory, SchemaNode schemaNode) {
        this.factory = factory;
        this.schemaNode = schemaNode;
        this.validators = factory.getValidators(schemaNode.getNode());
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        for (KeywordValidator validator : this.validators) {
            validator.validateInstance(context, report, instance);
        }
        if (!instance.isContainerNode()) {
            return false;
        }
        this.instanceType = NodeType.getNodeType(instance);
        return true;
    }

    @Override
    public JsonValidator next() {
        return this.instanceType == NodeType.ARRAY ? new ArrayJsonValidator(this.factory, this.schemaNode) : new ObjectJsonValidator(this.factory, this.schemaNode);
    }
}

