/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaNode;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.SyntaxJsonValidator;

public final class RefResolverJsonValidator
implements JsonValidator {
    private final JsonSchemaFactory factory;
    private SchemaNode schemaNode;

    public RefResolverJsonValidator(JsonSchemaFactory factory, SchemaNode schemaNode) {
        this.factory = factory;
        this.schemaNode = schemaNode;
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        JsonNode refNode;
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        SchemaContainer container = context.getContainer();
        JsonNode node = this.schemaNode.getNode();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                report.addMessage("ref loop detected: " + refs);
                return false;
            }
            if (!source.contains(target)) {
                try {
                    container = this.factory.getSchema(target.getRootAsURI());
                    context.setContainer(container);
                }
                catch (JsonSchemaException e) {
                    report.addMessage(e.getMessage());
                    return false;
                }
            }
            if (!(node = target.getFragment().resolve(container.getSchema())).isMissingNode()) continue;
            report.addMessage("dangling JSON Ref: " + target);
            return false;
        }
        this.schemaNode = new SchemaNode(container, node);
        return true;
    }

    @Override
    public JsonValidator next() {
        return new SyntaxJsonValidator(this.factory, this.schemaNode);
    }
}

