/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DependenciesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new DependenciesSyntaxChecker();

    private DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode schema) {
        block4: for (JsonNode value : schema.get(this.keyword)) {
            switch (NodeType.getNodeType(value)) {
                case ARRAY: {
                    for (JsonNode element : value) {
                        if (element.isTextual()) continue;
                        messages.add("array element is not a string");
                    }
                }
                case OBJECT: 
                case STRING: {
                    continue block4;
                }
            }
            messages.add("dependencies element has wrong type");
        }
    }
}

