/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.validator.ContainerValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

final class ArrayValidator
extends ContainerValidator {
    private final JsonNode additionalItems;
    private final List<JsonNode> items;

    ArrayValidator(JsonValidatorCache cache, SchemaNode schemaNode) {
        super(cache, schemaNode);
        JsonNode node = this.schema.path("items");
        if (node.isObject()) {
            this.additionalItems = node;
            this.items = Collections.emptyList();
            return;
        }
        this.items = ImmutableList.copyOf((Iterable)node);
        node = this.schema.path("additionalItems");
        this.additionalItems = node.isObject() ? node : EMPTY_SCHEMA;
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer orig = context.getContainer();
        JsonPointer pwd = report.getPath();
        for (int i = 0; i < instance.size(); ++i) {
            SchemaNode subNode = new SchemaNode(orig, this.getSchema(i));
            JsonNode element = instance.get(i);
            report.setPath(pwd.append(i));
            JsonValidator validator = this.cache.getValidator(subNode);
            validator.validate(context, report, element);
            context.setContainer(orig);
        }
        report.setPath(pwd);
        return false;
    }

    private JsonNode getSchema(int index) {
        return index >= this.items.size() ? this.additionalItems : this.items.get(index);
    }
}

