/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.keyword.KeywordFactory;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.validator.InstanceValidator;
import org.eel.kitchen.jsonschema.validator.JsonResolver;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

public final class JsonValidatorCache {
    private final LoadingCache<SchemaNode, JsonValidator> cache;
    private final JsonResolver resolver;
    private final SyntaxValidator syntaxValidator;
    private final KeywordFactory keywordFactory;

    public JsonValidatorCache(KeywordBundle bundle, SchemaRegistry registry) {
        this.resolver = new JsonResolver(registry);
        this.syntaxValidator = new SyntaxValidator(bundle);
        this.keywordFactory = new KeywordFactory(bundle);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build(this.cacheLoader());
    }

    public JsonValidator getValidator(SchemaNode schemaNode) {
        return (JsonValidator)this.cache.getUnchecked((Object)schemaNode);
    }

    private CacheLoader<SchemaNode, JsonValidator> cacheLoader() {
        final JsonValidatorCache myself = this;
        return new CacheLoader<SchemaNode, JsonValidator>(){

            public JsonValidator load(SchemaNode key) {
                SchemaNode realNode = key;
                if (realNode.getNode().has("$ref")) {
                    try {
                        realNode = JsonValidatorCache.this.resolver.resolve(key);
                    }
                    catch (JsonSchemaException e) {
                        return new FailingValidator(e.getMessage());
                    }
                }
                ArrayList<String> messages = new ArrayList<String>();
                JsonValidatorCache.this.syntaxValidator.validate(messages, realNode.getNode());
                if (!messages.isEmpty()) {
                    return new FailingValidator(messages);
                }
                Set<KeywordValidator> validators = JsonValidatorCache.this.keywordFactory.getValidators(realNode.getNode());
                return new InstanceValidator(myself, realNode, validators);
            }
        };
    }

    private static final class FailingValidator
    implements JsonValidator {
        private final List<String> messages;

        private FailingValidator(String message) {
            this.messages = ImmutableList.of((Object)message);
        }

        private FailingValidator(List<String> messages) {
            this.messages = ImmutableList.copyOf(messages);
        }

        @Override
        public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
            report.addMessages(this.messages);
            return false;
        }
    }
}

