/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

final class JsonResolver {
    private final SchemaRegistry registry;

    JsonResolver(SchemaRegistry registry) {
        this.registry = registry;
    }

    SchemaNode resolve(SchemaNode schemaNode) throws JsonSchemaException {
        JsonNode refNode;
        SchemaContainer container = schemaNode.getContainer();
        JsonNode node = schemaNode.getNode();
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                throw new JsonSchemaException("ref loop detected: " + refs);
            }
            if (!source.contains(target)) {
                container = this.registry.get(target.getRootAsURI());
            }
            if (!(node = target.getFragment().resolve(container.getSchema())).isMissingNode()) continue;
            throw new JsonSchemaException("dangling JSON Reference " + target);
        }
        return new SchemaNode(container, node);
    }
}

