/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.bundle.KeywordBundles;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.uri.URIDownloader;
import org.eel.kitchen.jsonschema.uri.URIManager;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;

public final class JsonSchemaFactory {
    private final SchemaRegistry registry;
    private final JsonValidatorCache cache;

    private JsonSchemaFactory(Builder builder) {
        this.registry = new SchemaRegistry(builder.uriManager, builder.namespace);
        this.cache = new JsonValidatorCache(builder.bundle, this.registry);
    }

    public SchemaContainer registerSchema(JsonNode schema) throws JsonSchemaException {
        return this.registry.register(schema);
    }

    public SchemaContainer getSchema(URI uri) throws JsonSchemaException {
        return this.registry.get(uri);
    }

    public JsonSchema createSchema(SchemaContainer container) {
        return this.createSchema(container, container.getSchema());
    }

    public JsonSchema createSchema(SchemaContainer container, String path) {
        ObjectNode node = JsonNodeFactory.instance.objectNode().put("$ref", path);
        return this.createSchema(container, (JsonNode)node);
    }

    private JsonSchema createSchema(SchemaContainer container, JsonNode schema) {
        return new JsonSchema(this.cache, container, schema);
    }

    public JsonValidatorCache getValidatorCache() {
        return this.cache;
    }

    public static final class Builder {
        private final KeywordBundle bundle;
        private final URIManager uriManager;
        private URI namespace = URI.create("");

        public Builder() {
            this(KeywordBundles.defaultBundle());
        }

        public Builder(KeywordBundle bundle) {
            this.bundle = bundle;
            this.uriManager = new URIManager();
        }

        public Builder registerScheme(String scheme, URIDownloader downloader) {
            this.uriManager.registerScheme(scheme, downloader);
            return this;
        }

        public Builder unregisterScheme(String scheme) {
            this.uriManager.unregisterScheme(scheme);
            return this;
        }

        public Builder registerKeyword(Keyword keyword) {
            this.bundle.registerKeyword(keyword);
            return this;
        }

        public Builder unregisterKeyword(String name) {
            this.bundle.unregisterKeyword(name);
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = URI.create(namespace);
            return this;
        }

        public Builder addRedirection(String from, String to) {
            this.uriManager.addRedirection(from, to);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this);
        }
    }
}

