/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonPointer;

public final class ValidationReport {
    private static final JsonPointer ROOT;
    private final ListMultimap<JsonPointer, String> msgMap = ArrayListMultimap.create();
    private JsonPointer path;

    public ValidationReport() {
        this(ROOT);
    }

    private ValidationReport(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public void addMessage(String message) {
        this.msgMap.put((Object)this.path, (Object)message);
    }

    public void addMessages(List<String> messages) {
        this.msgMap.putAll((Object)this.path, messages);
    }

    public boolean isSuccess() {
        return this.msgMap.isEmpty();
    }

    public void mergeWith(ValidationReport other) {
        this.msgMap.putAll(other.msgMap);
    }

    public ValidationReport copy() {
        return new ValidationReport(this.path);
    }

    public List<String> getMessages() {
        TreeSet paths = new TreeSet(this.msgMap.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonPointer path : paths) {
            for (String msg : this.msgMap.get((Object)path)) {
                builder.add((Object)(path + ": " + msg));
            }
        }
        return builder.build();
    }

    static {
        try {
            ROOT = new JsonPointer("");
        }
        catch (JsonSchemaException e) {
            throw new RuntimeException("WTF??", e);
        }
    }
}

