/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class PositiveIntegerSyntaxChecker
extends SimpleSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    final void checkValue(List<String> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.canConvertToInt()) {
            messages.add("value overflow");
            return;
        }
        if (node.intValue() < 0) {
            messages.add("value is negative");
        }
    }
}

