/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;

public final class DivisibleByKeywordValidator
extends NumericKeywordValidator {
    public DivisibleByKeywordValidator(JsonNode schema) {
        super("divisibleBy", schema);
    }

    @Override
    protected void validateLong(ValidationReport report, long instanceValue) {
        if (instanceValue % this.longValue != 0L) {
            report.addMessage("instance is not a multiple of divisibleBy");
        }
    }

    @Override
    protected void validateDecimal(ValidationReport report, BigDecimal instanceValue) {
        BigDecimal remainder = instanceValue.remainder(this.decimalValue);
        if (remainder.compareTo(BigDecimal.ZERO) != 0) {
            report.addMessage("instance is not a multiple of divisibleBy");
        }
    }
}

