/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import org.eel.kitchen.jsonschema.ref.JsonFragment;

final class IdFragment
extends JsonFragment {
    private final String id;

    IdFragment(String id) {
        this.id = id;
    }

    @Override
    public JsonNode resolve(JsonNode node) {
        String s;
        if (!node.isObject()) {
            return MissingNode.getInstance();
        }
        JsonNode idNode = node.path("id");
        if (idNode.isTextual() && this.id.equals(s = idNode.textValue().replaceFirst("^#", ""))) {
            return node;
        }
        for (JsonNode subNode : node) {
            JsonNode ret = this.resolve(subNode);
            if (ret.isMissingNode()) continue;
            return ret;
        }
        return MissingNode.getInstance();
    }

    @Override
    public String toString() {
        return this.id;
    }
}

