/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.CharMatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonFragment;

public final class JsonPointer
extends JsonFragment
implements Comparable<JsonPointer> {
    private static final CharMatcher SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher ESCAPE_CHAR = CharMatcher.is((char)'~');
    private static final BiMap<Character, Character> ESCAPE_REPLACEMENT_MAP = new ImmutableBiMap.Builder().put((Object)Character.valueOf('0'), (Object)Character.valueOf('~')).put((Object)Character.valueOf('1'), (Object)Character.valueOf('/')).build();
    private static final CharMatcher ESCAPED = CharMatcher.anyOf((CharSequence)"01");
    private static final CharMatcher SPECIAL = CharMatcher.anyOf((CharSequence)"~/");
    private final String fullPointer;
    private final List<String> elements;

    public JsonPointer(String input) throws JsonSchemaException {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonPointer.decode(input, (ImmutableList.Builder<String>)builder);
        this.elements = builder.build();
        this.fullPointer = input;
    }

    private JsonPointer(String fullPointer, List<String> elements) {
        this.fullPointer = fullPointer;
        this.elements = elements;
    }

    public JsonPointer append(String element) {
        ImmutableList newElements = new ImmutableList.Builder().addAll(this.elements).add((Object)element).build();
        return new JsonPointer(this.fullPointer + '/' + JsonPointer.refTokenEncode(element), (List<String>)newElements);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    @Override
    public JsonNode resolve(JsonNode node) {
        JsonNode ret = node;
        for (String pathElement : this.elements) {
            if (!ret.isContainerNode()) {
                return MissingNode.getInstance();
            }
            if (ret.isObject()) {
                ret = ret.path(pathElement);
            } else {
                try {
                    ret = ret.path(Integer.parseInt(pathElement));
                }
                catch (NumberFormatException ignored) {
                    return MissingNode.getInstance();
                }
            }
            if (!ret.isMissingNode()) continue;
            break;
        }
        return ret;
    }

    private static void decode(String input, ImmutableList.Builder<String> builder) throws JsonSchemaException {
        String victim = input;
        while (!victim.isEmpty()) {
            if (!victim.startsWith("/")) {
                throw JsonPointer.illegalPointer("reference token not preceeded by '/'");
            }
            victim = victim.substring(1);
            String cooked = JsonPointer.getNextRefToken(victim);
            victim = victim.substring(cooked.length());
            String raw = JsonPointer.refTokenDecode(cooked);
            builder.add((Object)raw);
        }
    }

    private static String getNextRefToken(String input) throws JsonSchemaException {
        StringBuilder sb = new StringBuilder();
        char[] array = input.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (inEscape) {
                if (!ESCAPED.matches(c)) {
                    throw JsonPointer.illegalPointer("bad escape sequence: ~ should be followed by one of " + ESCAPE_REPLACEMENT_MAP.keySet() + ", but was followed by '" + c + '\'');
                }
                sb.append(c);
                inEscape = false;
                continue;
            }
            if (SLASH.matches(c)) break;
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
            }
            sb.append(c);
        }
        if (inEscape) {
            throw JsonPointer.illegalPointer("bad escape sequence: ~ not followed by any token");
        }
        return sb.toString();
    }

    private static String refTokenDecode(String cooked) {
        StringBuilder sb = new StringBuilder(cooked.length());
        char[] array = cooked.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
                continue;
            }
            if (inEscape) {
                sb.append(ESCAPE_REPLACEMENT_MAP.get((Object)Character.valueOf(c)));
                inEscape = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String refTokenEncode(String raw) {
        char[] array;
        StringBuilder sb = new StringBuilder(raw.length());
        for (char c : array = raw.toCharArray()) {
            if (SPECIAL.matches(c)) {
                sb.append('~').append(ESCAPE_REPLACEMENT_MAP.inverse().get((Object)Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static JsonSchemaException illegalPointer(String message) {
        return new JsonSchemaException("illegal JSON Pointer: " + message);
    }

    @Override
    public int compareTo(JsonPointer other) {
        return this.fullPointer.compareTo(other.fullPointer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPointer other = (JsonPointer)obj;
        return this.fullPointer.equals(other.fullPointer);
    }

    public int hashCode() {
        return this.fullPointer.hashCode();
    }

    @Override
    public String toString() {
        return this.fullPointer;
    }
}

