/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonFragment;

public final class JsonRef {
    private static final URI HASHONLY_URI = URI.create("#");
    private static final URI EMPTY_URI = URI.create("");
    private static final JsonRef EMPTY = new JsonRef(EMPTY_URI);
    private final URI uri;
    private final URI locator;
    private final JsonFragment fragment;

    private JsonRef(URI uri) {
        try {
            this.locator = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), "");
            this.uri = uri.getFragment() == null ? this.locator : uri;
            this.fragment = JsonFragment.fromFragment(this.uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("WTF??", e);
        }
    }

    public static JsonRef fromURI(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI must not be null");
        URI normalized = uri.normalize();
        if (HASHONLY_URI.equals(normalized) || EMPTY_URI.equals(normalized)) {
            return EMPTY;
        }
        return new JsonRef(normalized);
    }

    public static JsonRef fromString(String s) throws JsonSchemaException {
        Preconditions.checkNotNull((Object)s, (Object)"string must not be null");
        try {
            return JsonRef.fromURI(new URI(s));
        }
        catch (URISyntaxException e) {
            throw new JsonSchemaException("invalid URI: " + s, e);
        }
    }

    public static JsonRef fromNode(JsonNode node) throws JsonSchemaException {
        Preconditions.checkNotNull((Object)node, (Object)"node must not be null");
        return node.isTextual() ? JsonRef.fromString(node.textValue()) : EMPTY;
    }

    public static JsonRef emptyRef() {
        return EMPTY;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute() && this.fragment.isEmpty();
    }

    public JsonRef resolve(JsonRef other) {
        if (other.uri.isAbsolute()) {
            return other;
        }
        URI targetURI = "jar".equals(this.uri.getScheme()) ? this.resolveJarURI(other) : this.uri.resolve(other.uri);
        return new JsonRef(targetURI);
    }

    public URI getRootAsURI() {
        return this.locator;
    }

    public JsonFragment getFragment() {
        return this.fragment;
    }

    public boolean contains(JsonRef other) {
        return this.locator.equals(other.locator);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRef that = (JsonRef)obj;
        return this.uri.equals(that.uri);
    }

    public String toString() {
        return this.uri.toString();
    }

    private URI resolveJarURI(JsonRef other) {
        String str = this.uri.toString();
        int idx = str.indexOf(33);
        String jarPath = str.substring(0, idx + 1);
        String sourceEntry = str.substring(idx + 1);
        String targetEntry = URI.create(sourceEntry).resolve(other.uri).toString();
        return URI.create(jarPath + targetEntry);
    }
}

