/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.validator.ArrayValidator;
import org.eel.kitchen.jsonschema.validator.ContainerValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;
import org.eel.kitchen.jsonschema.validator.ObjectValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

final class InstanceValidator
implements JsonValidator {
    private final JsonValidatorCache cache;
    private final SchemaNode schemaNode;
    private final Set<KeywordValidator> validators;

    InstanceValidator(JsonValidatorCache cache, SchemaNode schemaNode, Set<KeywordValidator> validators) {
        this.validators = ImmutableSet.copyOf(validators);
        this.schemaNode = schemaNode;
        this.cache = cache;
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer orig = context.getContainer();
        context.setContainer(this.schemaNode.getContainer());
        for (KeywordValidator validator : this.validators) {
            validator.validateInstance(context, report, instance);
        }
        if (!instance.isContainerNode()) {
            context.setContainer(orig);
            return false;
        }
        ContainerValidator validator = instance.isArray() ? new ArrayValidator(this.cache, this.schemaNode) : new ObjectValidator(this.cache, this.schemaNode);
        validator.validate(context, report, instance);
        context.setContainer(orig);
        return false;
    }
}

