/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class IPV6FormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new IPV6FormatSpecifier();
    private static final int IPV6_LENGTH = 16;

    private IPV6FormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 16) {
            return;
        }
        ValidationMessage.Builder msg = IPV6FormatSpecifier.newMsg(fmt).setMessage("string is not a valid IPv6 address").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

