/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class RegexFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new RegexFormatSpecifier();

    private RegexFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        if (RhinoHelper.regexIsValid(value.textValue())) {
            return;
        }
        ValidationMessage.Builder msg = RegexFormatSpecifier.newMsg(fmt).setMessage("string is not a valid ECMA 262 regular expression").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

