/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class URIFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new URIFormatSpecifier();

    private URIFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        try {
            new URI(value.textValue());
        }
        catch (URISyntaxException ignored) {
            ValidationMessage.Builder msg = URIFormatSpecifier.newMsg(fmt).setMessage("string is not a valid URI").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

