/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class ArrayChildrenSyntaxChecker
extends SimpleSyntaxChecker {
    private final EnumSet<NodeType> childrenTypes;

    protected ArrayChildrenSyntaxChecker(String keyword, EnumSet<NodeType> childrenTypes, NodeType type, NodeType ... types) {
        super(keyword, type, types);
        this.childrenTypes = EnumSet.copyOf(childrenTypes);
    }

    @Override
    final void checkValue(ValidationMessage.Builder msg, List<ValidationMessage> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            return;
        }
        int index = 0;
        for (JsonNode value : node) {
            NodeType type = NodeType.getNodeType(value);
            if (!this.childrenTypes.contains((Object)type)) {
                msg.setMessage("incorrect type for array element").addInfo("expected", this.childrenTypes).addInfo("found", type).addInfo("index", index);
                messages.add(msg.build());
            }
            ++index;
        }
    }
}

