/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DependenciesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final EnumSet<NodeType> VALID_DEPENDENCY_TYPES = EnumSet.of(NodeType.OBJECT, NodeType.ARRAY, NodeType.STRING);
    private static final SyntaxChecker instance = new DependenciesSyntaxChecker();

    private DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        SortedMap<String, JsonNode> map = JacksonUtils.nodeToTreeMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            DependenciesSyntaxChecker.analyzeDependency(entry, msg, messages);
        }
    }

    private static void analyzeDependency(Map.Entry<String, JsonNode> entry, Message.Builder msg, List<Message> messages) {
        String key = entry.getKey();
        JsonNode value = entry.getValue();
        if (value.isTextual() || value.isObject()) {
            return;
        }
        msg.clearInfo().addInfo("property", key);
        if (!value.isArray()) {
            msg.addInfo("found", NodeType.getNodeType(value)).addInfo("expected", VALID_DEPENDENCY_TYPES).setMessage("dependency value has incorrect type");
            messages.add(msg.build());
            return;
        }
        int idx = 0;
        for (JsonNode element : value) {
            NodeType type = NodeType.getNodeType(element);
            if (NodeType.STRING != type) {
                msg.addInfo("index", idx).addInfo("found", type).addInfo("expected", NodeType.STRING).setMessage("array dependency value has incorrect type");
                messages.add(msg.build());
            }
            ++idx;
        }
    }
}

