/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;

public final class SchemaContainer {
    private final JsonNode schema;
    private final JsonRef locator;

    public SchemaContainer(JsonNode schema) {
        JsonRef ref;
        try {
            ref = JsonRef.fromNode(schema.path("id"));
        }
        catch (JsonSchemaException ignored) {
            this.locator = JsonRef.emptyRef();
            this.schema = schema;
            return;
        }
        if (!ref.isAbsolute()) {
            ref = JsonRef.emptyRef();
        }
        this.locator = ref;
        this.schema = SchemaContainer.cleanup(schema);
    }

    SchemaContainer(URI uri, JsonNode node) {
        this.locator = JsonRef.fromURI(uri);
        this.schema = SchemaContainer.cleanup(node);
    }

    public boolean contains(JsonRef other) {
        return this.locator.contains(other);
    }

    public JsonNode resolve(JsonRef ref) {
        return ref.getFragment().resolve(this.schema);
    }

    public JsonRef getLocator() {
        return this.locator;
    }

    public JsonNode getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaContainer other = (SchemaContainer)obj;
        return this.locator.equals(other.locator);
    }

    public String toString() {
        return "locator: " + this.locator;
    }

    private static JsonNode cleanup(JsonNode schema) {
        if (!schema.has("id")) {
            return schema;
        }
        ObjectNode ret = (ObjectNode)schema.deepCopy();
        ret.remove("id");
        return ret;
    }
}

